#-----------------------------------------------------------------------------
#
#   File:           instructor.py
#   Module:         instructor
#   Package:        N/A
#   Project:        UC-05-2018 UR5 Robot Coffee Cart
#   Workspace:      Shotbot.rdk
#
#   Software:       Polyscope 3.0.16040
#   Firmware:       URControl 3.0.16040
#   Hardware:       UR5 (CB3UR5)
#
#   Target:         N/A
#   Environment:    RoboDK 3.4.7
#                   Python 3.4
#                   Doxygen 1.8.14
#
#   Author:         Rodney Elliott
#   Organisation:   University of Canterbury
#   Date:           23 October 2018
#
#-----------------------------------------------------------------------------
#
#   Copyright:      Rodney Elliott 2018
#                   University of Canterbury
#
#   This file is part of Shotbot.
#
#   Shotbot is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Shotbot is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Shotbot. If not, see <https://www.gnu.org/licenses/>.
#
#-----------------------------------------------------------------------------
##
#   @package instructor
#   @brief The instructor Python module.
#
#   <H3> Introduction </H3>
#
#   A module written for use by instructors (lecturers, technicians, teaching
#   assistants etc.) involved with the ENMT482 Robotics course offered by the
#   the University of Canterbury. Its purpose is to provide further functions
#   to help complete the UR5 Laboratory Assignment.
#

#-----------------------------------------------------------------------------
#   Modules
#-----------------------------------------------------------------------------
##
#   @brief RoboDK interface.
#
from robolink import *

##
#   @brief Robotics toolbox.
#
from robodk import *

##
#   @brief Useful math functions.
#
from math import radians

#-----------------------------------------------------------------------------
#   Globals
#-----------------------------------------------------------------------------
PATH = 'Z:/University/Projects/UC-05-2018 UR5 Robot Coffee Cart/RoboDK/'

#-----------------------------------------------------------------------------
#   Functions
#-----------------------------------------------------------------------------
##
#   @brief Set the pose of all single-TCP tools.
#
def set_single_pose_tools():
    tool = RDK.Item('Cup Tool Closed', ITEM_TYPE_TOOL)
    tcp = rotz(radians(-50)) * transl(0, 0, 48.94) * transl(-47, 0, 186.62)
    tool.setPoseTool(tcp)
    
    tool = RDK.Item('Cup Tool Open', ITEM_TYPE_TOOL)
    tool.setPoseTool(tcp)
    
    tool = RDK.Item('Paper Cup', ITEM_TYPE_TOOL)
    tool.setPoseTool(tcp * transl(-79, 0, 0))
        
    return

##
#   @brief Set the pose of the grinder tool.
#
#   The grinder tool has two TCPs available: the tip of the shock absorber,
#   which is used to push buttons on both the grinder and espresso machine;
#   and the edge of the unequal aluminium angle, which is used to pull the
#   dose lever on the grinder.
#
#   @param[in] pose Grinder tool pose. Valid selections are 'tip' or 'edge'.
#
def set_grinder_tool_pose(pose = 'tip'):
    if pose == 'tip':
        tcp = rotz(radians(-50)) * transl(0, 0, 48.94) * transl(0, 0, 103.33)
    elif pose == 'edge':
        tcp = rotz(radians(-50)) * transl(0, 0, 48.94) * transl(-50, 0, 67.57)
    else:
        raise Exception('Invalid grinder tool pose.')
    
    tool = RDK.Item('Grinder Tool', ITEM_TYPE_TOOL)
    tool.setPoseTool(tcp)
    
    return

##
#   @brief Set the pose of the portafilter tool.
#
#   The portafilter tool has two TCPs available: the centre of the coffee
#   basket, and the centre of the tool rest.
#
#   @param[in] pose Portafilter tool pose. Valid selections are 'rest' or
#       'basket'.
#
def set_portafilter_tool_pose(pose = 'rest'):
    if pose == 'rest':
        tcp = rotz(radians(-50)) * transl(0, 0, 48.94) * transl(-32, 0, 28.07)
    elif pose == 'basket':
        tcp = rotz(radians(-50)) * transl(0, 0, 48.94) * transl(4.73, 0, 145.12) * roty(radians(-7.5))
    else:
        raise Exception('Invalid portafilter tool pose.')
    
    tool = RDK.Item('Portafilter Tool', ITEM_TYPE_TOOL)
    tool.setPoseTool(tcp)
    
    return

#-----------------------------------------------------------------------------
#   Program
#-----------------------------------------------------------------------------
RDK = Robolink()

set_single_pose_tools()
set_grinder_tool_pose('tip')
set_portafilter_tool_pose('rest')

